*                                                                                  ;
 *    Reading in the 1980 PSID data                                                 ;
 *                                                                                  ;
 *            Karen Dynan 8/26/06                                                   ;
 *                                                                                  ;
 *    We read it all in and then output select variables to a flat                  ;
 *    file to be picked up by STATA.                                                ;
 *                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam80.raw' ;
 
 data one;
 
   infile 'F:\PSID\80FAM.DAT'  lrecl=1100 missover;
   INPUT
   V6901 1-3              V6902 4-7              V6903 8-9
   V6904 10-12            V6905 13-17            V6906 18
   V6907 19               V6908 20               V6909 21
   V6910 22               V6911 23               V6912 24
   V6913 25               V6914 26               V6915 27
   V6916 28               V6917 29-34            V6918 35
   V6919 36-40            V6920 41               V6921 42-45
   V6922 46               V6923 47-50            V6924 51
   V6925 52-55            V6926 56               V6927 57
   V6928 58               V6929 59-62            V6930 63
   V6931 64-67            V6932 68               V6933 69-72
   V6934 73-76            V6935 77               V6936 78-81
   V6937 82               V6938 83-86            V6939 87
   V6940 88-91            V6941 92               V6942 93-96
   V6943 97               V6944 98-100           V6945 101
   V6946 102-105          V6947 106              V6948 107-110
   V6949 111              V6950 112-115          V6951 116
   V6952 117-120          V6953 121              V6954 122-125
   V6955 126              V6956 127-129          V6957 130
   V6958 131              V6959 132-133          V6960 134
   V6961 135-139 .2       V6962 140-144          V6963 145-148
   V6964 149              V6965 150-153          V6966 154
   V6967 155-158          V6968 159              V6969 160
   V6970 161-163          V6971 164              V6972 165-168
   V6973 169              V6974 170-173          V6975 174
   V6976 175-178          V6977 179              V6978 180-181
   V6979 182-186          V6980 187-191          V6981 192-196
   V6982 197              V6983 198-202          V6984 203-207
   V6985 208-211          V6986 212-215          V6987 216
   V6988 217-221          V6989 222              V6990 223-227
   V6991 228-232          V6992 233-236          V6993 237-240
   V6994 241-245          V6995 246-249          V6996 250-254
   V6997 255              V6998 256-261          V6999 262-266
   V7000 267              V7001 268-269          V7002 270
   V7003 271-275          V7004 276              V7005 277-280
   V7006 281-285          V7007 286-290          V7008 291-295
   V7009 296-300          V7010 301-304          V7011 305-309
   V7012 310-313          V7013 314-317          V7014 318-322
   V7015 323              V7016 324-328          V7017 329-333
   V7018 334-335          V7019 336              V7020 337-341
   V7021 342-343          V7022 344              V7023 345-349
   V7024 350-351          V7025 352              V7026 353-357
   V7027 358-359          V7028 360              V7029 361-365
   V7030 366-367          V7031 368              V7032 369-372
   V7033 373-377          V7034 378              V7035 379
   V7036 380-384          V7037 385-389          V7038 390-394
   V7039 395-399          V7040 400-404          V7041 405-409
   V7042 410-413          V7043 414-418          V7044 419-422
   V7045 423-426          V7046 427-431          V7047 432
   V7048 433              V7049 434              V7050 435-438
   V7051 439-442          V7052 443-446          V7053 447-450
   V7054 451-454          V7055 455-458          V7056 459-462
   V7057 463-466          V7058 467-470          V7059 471-474
   V7060 475-478          V7061 479-482          V7062 483-486
   V7063 487-488          V7064 489-492          V7065 493-495
   V7066 496-497          V7067 498-499          V7068 500
   V7069 501-502          V7070 503-504          V7071 505-506
   V7072 507              V7073 508              V7074 509
   V7075 510              V7076 511              V7077 512
   V7078 513              V7079 514-518          V7080 519
   V7081 520              V7082 521              V7083 522
   V7084 523              V7085 524              V7086 525-526
   V7087 527              V7088 528              V7089 529
   V7090 530-531          V7091 532              V7092 533
   V7093 534              V7094 535              V7095 536
   V7096 537              V7097 538              V7098 539
   V7099 540              V7100 541-542          V7101 543-544
   V7102 545-547          V7103 548-549          V7104 550
   V7105 551              V7106 552              V7107 553
   V7108 554              V7109 555-556          V7110 557
   V7111 558-559          V7112 560              V7113 561-562
   V7114 563              V7115 564-565          V7116 566
   V7117 567-568          V7118 569-570          V7119 571-572
   V7120 573              V7121 574              V7122 575-578
   V7123 579              V7124 580-583          V7125 584-587
   V7126 588-591          V7127 592              V7128 593-596
   V7129 597              V7130 598-599          V7131 600
   V7132 601-604          V7133 605-606          V7134 607-608
   V7135 609              V7136 610-613          V7137 614
   V7138 615              V7139 616              V7140 617
   V7141 618              V7142 619-620          V7143 621
   V7144 622              V7145 623              V7146 624
   V7147 625              V7148 626-627          V7149 628-631
   V7150 632              V7151 633              V7152 634
   V7153 635-638          V7154 639              V7155 640-643
   V7156 644              V7157 645-646          V7158 647
   V7159 648-649          V7160 650-651          V7161 652
   V7162 653-654          V7163 655              V7164 656-657
   V7165 658              V7166 659-660          V7167 661
   V7168 662-663          V7169 664              V7170 665-666
   V7171 667              V7172 668-669          V7173 670-671
   V7174 672-673          V7175 674-675          V7176 676
   V7177 677              V7178 678-679          V7179 680
   V7180 681-682          V7181 683-684          V7182 685-686
   V7183 687-688          V7184 689              V7185 690
   V7186 691              V7187 692-693          V7188 694
   V7189 695              V7190 696              V7191 697
   V7192 698              V7193 699              V7194 700
   V7195 701              V7196 702              V7197 703
   V7198 704-705          V7199 706-707          V7200 708-710
   V7201 711-712          V7202 713              V7203 714
   V7204 715-716          V7205 717              V7206 718-719
   V7207 720              V7208 721-722          V7209 723
   V7210 724-725          V7211 726              V7212 727-728
   V7213 729-730          V7214 731-732          V7215 733
   V7216 734              V7217 735-738          V7218 739-742
   V7219 743              V7220 744              V7221 745-746
   V7222 747-748          V7223 749-750          V7224 751-752
   V7225 753              V7226 754-755          V7227 756
   V7228 757              V7229 758-759          V7230 760
   V7231 761-762          V7232 763-764          V7233 765
   V7234 766-767          V7235 768              V7236 769-770
   V7237 771              V7238 772-773          V7239 774
   V7240 775-776          V7241 777              V7242 778-779
   V7243 780              V7244 781-782          V7245 783-784
   V7246 785-786          V7247 787-788          V7248 789
   V7249 790              V7250 791-792          V7251 793
   V7252 794-795          V7253 796-797          V7254 798-799
   V7255 800-801          V7256 802              V7257 803
   V7258 804              V7259 805              V7260 806
   V7261 807              V7262 808              V7263 809
   V7264 810              V7265 811-812          V7266 813-814
   V7267 815              V7268 816              V7269 817
   V7270 818              V7271 819              V7272 820
   V7273 821              V7274 822              V7275 823
   V7276 824              V7277 825              V7278 826
   V7279 827              V7280 828              V7281 829
   V7282 830              V7283 831              V7284 832
   V7285 833              V7286 834              V7287 835
   V7288 836              V7289 837              V7290 838
   V7291 839              V7292 840              V7293 841
   V7294 842              V7295 843              V7296 844
   V7297 845              V7298 846              V7299 847
   V7300 848              V7301 849              V7302 850
   V7303 851              V7304 852              V7305 853
   V7306 854              V7307 855              V7308 856
   V7309 857              V7310 858              V7311 859
   V7312 860              V7313 861              V7314 862
   V7315 863              V7316 864              V7317 865
   V7318 866              V7319 867              V7320 868
   V7321 869              V7322 870              V7323 871
   V7324 872              V7325 873              V7326 874
   V7327 875              V7328 876              V7329 877
   V7330 878              V7331 879              V7332 880-881
   V7333 882-883          V7334 884              V7335 885-886
   V7336 887-888          V7337 889              V7338 890-891
   V7339 892-893          V7340 894              V7341 895
   V7342 896              V7343 897              V7344 898
   V7345 899              V7346 900-901          V7347 902
   V7348 903              V7349 904              V7350 905
   V7351 906              V7352 907              V7353 908-909
   V7354 910-911          V7355 912-913          V7356 914
   V7357 915              V7358 916-917          V7359 918-920
   V7360 921-922          V7361 923-925          V7362 926
   V7363 927              V7364 928              V7365 929-930
   V7366 931-932          V7367 933-934          V7368 935-936
   V7369 937              V7370 938              V7371 939
   V7372 940              V7373 941-942          V7374 943-945
   V7375 946              V7376 947              V7377 948
   V7378 949              V7379 950              V7380 951
   V7381 952              V7382 953              V7383 954-955
   V7384 956-957          V7385 958-959          V7386 960
   V7387 961-962          V7388 963              V7389 964
   V7390 965              V7391 966              V7392 967
   V7393 968              V7394 969              V7395 970
   V7396 971              V7397 972              V7398 973
   V7399 974-978          V7400 979-980          V7401 981-984
   V7402 985-986          V7403 987-990          V7404 991-992
   V7405 993-996          V7406 997-998          V7407 999-1002
   V7408 1003-1004        V7409 1005-1008        V7410 1009-1010
   V7411 1011-1015        V7412 1016-1021        V7413 1022-1026
   V7414 1027-1031        V7415 1032-1035 .2     V7416 1036-1039
   V7417 1040-1043 .2     V7418 1044-1047 .2     V7419 1048
   V7420 1049             V7421 1050             V7422 1051
   V7423 1052             V7424 1053             V7425 1054-1055
   V7426 1056-1057        V7427 1058-1062        V7428 1063
   V7429 1064-1065 .1     V7430 1066-1067        V7431 1068
   V7432 1069             V7433 1070             V7434 1071
   V7435 1072             V7436 1073             V7437 1074
   V7438 1075             V7439 1076             V7440 1077
   V7441 1078             V7442 1079             V7443 1080
   V7444 1081             V7445 1082             V7446 1083
   V7447 1084             V7448 1085             V7449 1086-1088
   V7450 1089             V7451 1090-1091        V7452 1092
   V7453 1093             V7454 1094             V7455 1095
   V7456 1096-1099        V7457 1100;

* SAS LABEL STATEMENT;

LABEL
   V6901 = "STUDY NUMBER (701)"
   V6902 = "1980 INTERVIEW NUMBER"
   V6903 = "CURRENT STATE"
   V6904 = "CURRENT COUNTY"
   V6905 = "CURRENT ST& CNTY"
   V6906 = "SIZE LGST CTY SMSA 1980"
   V6907 = "COLOR COVERSHEET 1980"
   V6908 = "WHETHER REFUSED 1980"
   V6909 = "TELEPHONE INT? 1980"
   V6910 = "FAM COMP CHANGE 1980"
   V6911 = "# MOVED IN 1980"
   V6912 = "WHO MOVED IN 1980"
   V6913 = "# MOVED OUT 1980"
   V6914 = "WHO MOVED OUT 1980"
   V6915 = "CURRENT FAM COMP 1980"
   V6916 = "QUALITY OF MATCH 1980"
   V6917 = "1980 HOUSE VALUE (B7)"
   V6918 = "ACC 80 HOUSE VALUE"
   V6919 = "REM MORT. PRIN 80 (B9)"
   V6920 = "ACC REM MORT PRIN"
   V6921 = "ANN MORT $  1980 (B10)"
   V6922 = "ACC ANN MORT $"
   V6923 = "ANN PROP TAX 80 (B13)"
   V6924 = "ACC ANN PROP TAX"
   V6925 = "ANN RENT 1980 (B14)"
   V6926 = "ACC ANN RENT"
   V6927 = "FURNISHED? (B15)"
   V6928 = "INCLUDE HEAT? (B18)"
   V6929 = "ANN $  IF RENT (B20)"
   V6930 = "ACC ANN $  IF RENT"
   V6931 = "ANN UTILITIES 1979"
   V6932 = "ACC ANN UTILITIES"
   V6933 = "GOV SUBSDY HEATCOST (B4A"
   V6934 = "HD ANN WRK HRS IN 79"
   V6935 = "ACC HD 79 WRK HRS"
   V6936 = "HD HRS WRK LOST OTH ILL"
   V6937 = "ACC HD HR LOST OTH ILL"
   V6938 = "HD HRS WRK LOST OWN ILL"
   V6939 = "ACC HD HR LOST OWN ILL"
   V6940 = "HD STRIKE HRS 79"
   V6941 = "ACC HD STRIKE HRS 79"
   V6942 = "HD UNEMP HRS 79"
   V6943 = "ACC HD UNEMP HRS 79"
   V6944 = "HD TRAV TO WRK HRS 79"
   V6945 = "ACC HD TRAV TO WRK HR 79"
   V6946 = "WF ANN WRK HRS IN 79"
   V6947 = "ACC WF 79 WRK HRS"
   V6948 = "WF HRS WRK LOST OTH ILL"
   V6949 = "ACC WF HR LOST OTH ILL"
   V6950 = "WF HRS WRK LOST OWN ILL"
   V6951 = "ACC WF HR LOST OWN ILL"
   V6952 = "WF STRIKE HRS 79"
   V6953 = "ACC WF STRIK HRS 79"
   V6954 = "WF UNEMP HRS 79"
   V6955 = "ACC WF UNEMP HRS 79"
   V6956 = "WF TRAV TO WRK HRS 79"
   V6957 = "ACC WF TRAV TO WRK HR 79"
   V6958 = "# MAJOR ADULTS"
   V6959 = "1980 FAMILY SIZE"
   V6960 = "# REQUIRED ROOMS"
   V6961 = "1980 WEEKLY FOOD NEED"
   V6962 = "1980 ANN NEED STANDARD"
   V6963 = "WF ANN HSEWRK HRS (J5)"
   V6964 = "ACC WF ANN HSEWRK HRS"
   V6965 = "HD ANN HSEWRK HRS (J6)"
   V6966 = "ACC HD ANN HSEWRK HRS"
   V6967 = "OTH ANN HSEWRK HRS (J10)"
   V6968 = "ACC OTH ANN HSEWRK HRS"
   V6969 = "# FD ST ISSUED FOR (J13)"
   V6970 = "$ VLUE FD ST LST MO (J14)"
   V6971 = "ACC $ VALUE FD ST LAST MO"
   V6972 = "ANN FD $  EXCL FD STMP"
   V6973 = "ACC ANN FOOD $"
   V6974 = "ANN $  EATING OUT"
   V6975 = "ACC ANN $  EATING OUT"
   V6976 = "$ VALUE FD ST 1979"
   V6977 = "ACC $  VALUE FD ST 1979"
   V6978 = "# MOS USED FD STMP 1979"
   V6979 = "LABOR PART FARM Y 1979"
   V6980 = "LABOR PART BUS Y 1979"
   V6981 = "HEAD 1979 WAGES"
   V6982 = "ACC HEAD 1979 WAGES"
   V6983 = "HD BONUS,OT,COMM 1979"
   V6984 = "HD PROF PRAC/TRADE 1979"
   V6985 = "LAB PART MKT GRDNG 1979"
   V6986 = "LAB PART ROOM 1979"
   V6987 = "ACC HD LABOR Y EXCL WAGE"
   V6988 = "WIFE 1979 LABOR/WAGE"
   V6989 = "ACC WF 79 LABOR/WAGE"
   V6990 = "ASSET PART FARM Y 1979"
   V6991 = "ASSET PART BUS Y 1979"
   V6992 = "ASSET PART MKT GRDNG 79"
   V6993 = "ASSET PART ROOMERS 1979"
   V6994 = "HD RENT/INT/DIVDNDS 1979"
   V6995 = "ALIMONY Y HEAD 1979"
   V6996 = "WIFE 1979 ASSET Y"
   V6997 = "ACC H+W 1979 ASSET Y"
   V6998 = "H+W 1979 TAXABLE Y"
   V6999 = "H+W 1979 SUPP OTH NONFU"
   V7000 = "H+W 1979 # DEPENDENTS"
   V7001 = "H+W TOTAL 1979 EXEMPTION"
   V7002 = "TAX TABLE USED"
   V7003 = "H+W 1979 ADC/AFDC"
   V7004 = "ACC H+W 1979 ADC/AFDC"
   V7005 = "H+W 1979 SSI"
   V7006 = "H+W 1979 OTHER WELFARE"
   V7007 = "H+W 1979 SOCIAL SECURITY"
   V7008 = "HD OTHER RETIREMENT 1979"
   V7009 = "HD 1979 UNEMP COMP"
   V7010 = "HD 1979 WRKMNS COMP"
   V7011 = "HD CHILD SUPPORT 1979"
   V7012 = "HD 1979 HELP FROM REL"
   V7013 = "HD OTHER TRANSFER Y 1979"
   V7014 = "WF OTHER TRANSFER Y 1979"
   V7015 = "ACC H+W 79 TRAN Y NONADC"
   V7016 = "H+W TOT TRANSFER Y 1979"
   V7017 = "TXBL Y 1ST XTRA EARNER"
   V7018 = "#EXEMPTS 1ST XTRA EARNER"
   V7019 = "TAXTABLE 1ST XTRA EARNER"
   V7020 = "TXBL Y 2ND XTRA EARNER"
   V7021 = "#EXEMPTS 2ND XTRA EARNER"
   V7022 = "TAXTABLE 2ND XTRA EARNER"
   V7023 = "TXBL Y 3RD XTRA EARNER"
   V7024 = "#EXEMPTS 3RD XTRA EARNER"
   V7025 = "TAXTABLE 3RD XTRA EARNER"
   V7026 = "TXBL Y 4TH XTRA EARNER"
   V7027 = "#EXEMPTS 4TH XTRA EARNER"
   V7028 = "TAXTABLE 4TH XTRA EARNER"
   V7029 = "TXBL Y 5TH XTRA EARNER"
   V7030 = "#EXEMPTS 5TH XTRA EARNER"
   V7031 = "TAXTABLE 5TH XTRA EARNER"
   V7032 = "OTH ANN WRK HRS 1979"
   V7033 = "TOT OTH ANN TXBLE Y 1979"
   V7034 = "ACC OTH ANN TX Y 79"
   V7035 = "BKT OTH 1979 ASSET Y"
   V7036 = "OTH 1979 ADC/AFDC"
   V7037 = "OTH 1979 SSI"
   V7038 = "OTH 1979 OTHER WELFARE"
   V7039 = "OTH 1979 SOCIAL SECURITY"
   V7040 = "OTH 1979 OTHER RET"
   V7041 = "OTH 1979 UNEMP COMP"
   V7042 = "OTH 1979 WRKMNS COMP"
   V7043 = "OTH 1979 CHILD SUPP"
   V7044 = "OTH 1979 HLP FRM RLTVS"
   V7045 = "OTH 1979 MISC TRANS"
   V7046 = "OTH 1979 TOT TRANS Y"
   V7047 = "ACC 79 TOT TRANS Y"
   V7048 = "# WITH 79 Y"
   V7049 = "# WITH 79 LABOR Y"
   V7050 = "1968 ID"
   V7051 = "1969 ID"
   V7052 = "1970 ID"
   V7053 = "1971 ID"
   V7054 = "1972 ID"
   V7055 = "1973 ID"
   V7056 = "1974 ID"
   V7057 = "1975 ID"
   V7058 = "1976 ID"
   V7059 = "1977 ID"
   V7060 = "1978 ID"
   V7061 = "1979 ID"
   V7062 = "INTR ID #"
   V7063 = "INTR INT #"
   V7064 = "DATE OF INT"
   V7065 = "LENGTH OF INT"
   V7066 = "# IN FU"
   V7067 = "AGE OF HEAD"
   V7068 = "SEX OF HEAD"
   V7069 = "AGE OF WIFE"
   V7070 = "# CHILDREN IN FU"
   V7071 = "AGE YOUNGEST CHILD"
   V7072 = "A2 PUB TRANS NEARBY?"
   V7073 = "A3 WTR PUB TRANS GD ENUF"
   V7074 = "A4 DU INSIDE CITY LIMITS"
   V7075 = "A5 DIST TO CNTR CITY"
   V7076 = "A6 DIST CNTR NRST CITY"
   V7077 = "A7 OWN CAR/TRUCK"
   V7078 = "A8 # CAR/TRUCK OWN"
   V7079 = "A9 # MI DRIVEN-ALL CARS"
   V7080 = "B1 ACTUAL # ROOMS"
   V7081 = "B2 TYPE DWELLING"
   V7082 = "B3 HOW HEATED?"
   V7083 = "B4 RECD GOVT HTNG SUBSDY"
   V7084 = "B5 OWN/RENT OR WHAT"
   V7085 = "B8 MORTGAGE?"
   V7086 = "B11 # YRS LEFT ON MORT"
   V7087 = "B12 2ND MORTGAGE?"
   V7088 = "B19 RSN NETR OWN/RENT"
   V7089 = "B23 MOVE SINCE SPR 1979"
   V7090 = "B24 MONTH MOVED"
   V7091 = "B25 WHY MOVED"
   V7092 = "B26 WTR MIGHT MOVE"
   V7093 = "B27 LIKELY HOOD OF MOVE"
   V7094 = "B28 WHY MIGHT MOVE"
   V7095 = "C1 EMP STATUS HEAD"
   V7096 = "C2 WORK SELF/OTR (HD-E)"
   V7097 = "C3 WORK FOR GOVT (HD-E)"
   V7098 = "C4 JOB UNION (HD-E)"
   V7099 = "C5 BLNG THT UNION (HD-E)"
   V7100 = "C6-7 OCC:2DIGIT (HD-E)"
   V7101 = "C8 INDUSTRY (HD-E)"
   V7102 = "C9 # MOS THIS JOB (HD-E)"
   V7103 = "C10 MO START JOB (HD-E)"
   V7104 = "C12 HPND PRE JOB (HD-E)"
   V7105 = "C13 JOB BETTER? (HD-E)"
   V7106 = "C14 WHY BET/WRSE (HD-E)"
   V7107 = "C15 JOB PAY MORE (HD-E)"
   V7108 = "C16 WTR OTR ILL (HD-E)"
   V7109 = "C17 # WKS OTR ILL (HD-E)"
   V7110 = "C18 WTR SELF ILL (HD-E)"
   V7111 = "C19 #WKS SELF ILL (HD-E)"
   V7112 = "C20 WTR VACATION (HD-E)"
   V7113 = "C21 #WKS VACAT (HD-E)"
   V7114 = "C22 WTR STRIKE (HD-E)"
   V7115 = "C23 #WKS STRIKE (HD-E)"
   V7116 = "C24 WTR UNEMP (HD-E)"
   V7117 = "C25 #WKS UNEMP (HD-E)"
   V7118 = "C26 #WKS WORKED (HD-E)"
   V7119 = "C27 # HR/WK WRKD (HD-E)"
   V7120 = "C28 WTR WRK OT (HD-E)"
   V7121 = "C30 SLRY/HRLY/OTHR(HD-E)"
   V7122 = "C31 PAY/HRLY SLRY (HD-E)"
   V7123 = "C32 WTR PAID OTIME(HD-E)"
   V7124 = "C33 PY/HRLY SLRY OT(HD-E"
   V7125 = "C34 PAY/HR HRLY (HD-E)"
   V7126 = "C35 PY/HR HRLY OT (HD-E)"
   V7127 = "C36 HOW PAID (HD-E)"
   V7128 = "C37 PAY/HR OT-OTR (HD-E)"
   V7129 = "C38 WTR XTRA JOBS (HD-E)"
   V7130 = "C39 OCC-XTRA JOB (HD-E)"
   V7131 = "C40 #XTRA JOBS (HD-E)"
   V7132 = "C41 PAY/HR XT JOB (HD-E)"
   V7133 = "C42 #WKS XTRA JOB (HD-E)"
   V7134 = "C43 HR/WK XTR JOB (HD-E)"
   V7135 = "C44 MRE WRK AVAIL (HD-E)"
   V7136 = "C45 PY/HR WRK MRE (HD-E)"
   V7137 = "C46 WRK LESS? (HD-E)"
   V7138 = "C47 WNT WRK LESS (HD-E)"
   V7139 = "C48 WRK MORE? (HD-E)"
   V7140 = "C49 WRK LESS? (HD-E)"
   V7141 = "C50 WNT WRK LESS (HD-E)"
   V7142 = "C52 #MI TO WRK (HD-E)"
   V7143 = "C53 MODE TRAV WRK (HD-E)"
   V7144 = "C54 NEW JOB? (HD-E)"
   V7145 = "C55 LKNG NEW JOB (HD-E)"
   V7146 = "C56 WTR MOV NW JOB (HD-E"
   V7147 = "C57 WHY NOT MOVE (HD-E)"
   V7148 = "D1 OCC-JOB SOUGHT (HD-U)"
   V7149 = "D2 PY/HR JOB SGHT (HD-U)"
   V7150 = "D3 WTR NEED TRNG (HD-U)"
   V7151 = "D4 WTR LKNG JOB (HD-U)"
   V7152 = "D5 #PLAC LKD (HD-U)"
   V7153 = "D6 LOWEST PAY/HR (HD-U)"
   V7154 = "D7 WTR MOV FOR JOB (HD-U"
   V7155 = "D8 PAY/HR TO MOVE (HD-U)"
   V7156 = "D9 WHY NOT MOVE (HD-U)"
   V7157 = "D10 WKS LK FR WRK (HD-U)"
   V7158 = "D11 EVER HAD JOB (HD-U)"
   V7159 = "D12 OCC-LAST JOB (HD-U)"
   V7160 = "D13 IND-LAST JOB (HD-U)"
   V7161 = "D14 HPND LAST JOB (HD-U)"
   V7162 = "D15 YR LAST WRKD (HD-U)"
   V7163 = "D17 WTR VACATION (HD-U)"
   V7164 = "D18 #WKS VACAT (HD-U)"
   V7165 = "D19 WTR OTR ILL (HD-U)"
   V7166 = "D20 #WKS OTR ILL (HD-U)"
   V7167 = "D21 WTR SELF ILL (HD-U)"
   V7168 = "D22 #WKS SELF ILL (HD-U)"
   V7169 = "D23 WTR STRIKE (HD-U)"
   V7170 = "D24 #WKS STRIKE (HD-U)"
   V7171 = "D25 WTR UNEMP (HD-U)"
   V7172 = "D26 #WKS UNEMP (HD-U)"
   V7173 = "D27 #WKS WRKED (HD-U)"
   V7174 = "D28 HR/WK WRKED (HD-U)"
   V7175 = "D30 #MI TO WRK (HD-U)"
   V7176 = "D31 MODE TRAV WRK (HD-U)"
   V7177 = "E1 WTR RETIRED (HD-R)"
   V7178 = "E2 YEAR RETIRED (HD-R)"
   V7179 = "E3 WRK FOR $  (HD-R)"
   V7180 = "E4 OCCUPATION (HD-R)"
   V7181 = "E5 INDUSTRY (HD-R)"
   V7182 = "E6 #WKS WRKD (HD-R)"
   V7183 = "E7 HR/WK WRKD (HD-R)"
   V7184 = "E8 WRKNG NOW (HD-R)"
   V7185 = "E9 HPND LAST JOB (HD-R)"
   V7186 = "E10 JOB IN FUT (HD-R)"
   V7187 = "E11 WHEN GET JOB (HD-R)"
   V7188 = "E12 TYPE JOB (HD-R)"
   V7189 = "E13 NEED TRNG (HD-R)"
   V7190 = "E14 LK FOR JOB (HD-R)"
   V7191 = "E15 #PLAC LKD (HD-R)"
   V7192 = "F1 WIFE IN FU"
   V7193 = "F2 EMP STATUS WIFE"
   V7194 = "F3 WRK SELF/OTR (WF-E)"
   V7195 = "F4 WRK FOR GOVT (WF-E)"
   V7196 = "F5 JOB UNION (WF-E)"
   V7197 = "F6 BLNG THT UNION (WF-E)"
   V7198 = "F7-8 OCCUPATION (WF-E)"
   V7199 = "F9 INDUSTRY (WF-E)"
   V7200 = "F10 #MOS THIS JOB (WF-E)"
   V7201 = "F12 MO START JOB (WF-E)"
   V7202 = "F13 HPPN PRE JOB (WF-E)"
   V7203 = "F14 WTR OTR ILL (WF-E)"
   V7204 = "F15 #WKS OTR ILL (WF-E)"
   V7205 = "F16 WTR SELF ILL (WF-E)"
   V7206 = "F17 #WKS SELF ILL (WF-E)"
   V7207 = "F18 WTR VAC (WF-E)"
   V7208 = "F19 #WKS VAC (WF-E)"
   V7209 = "F20 WTR STRIKE (WF-E)"
   V7210 = "F21 #WKS STRIKE (WF-E)"
   V7211 = "F22 WTR UNEMP (WF-E)"
   V7212 = "F23 #WKS UNEMP (WF-E)"
   V7213 = "F24 #WKS WRKD (WF-E)"
   V7214 = "F25 HR/WK WRKD (WF-E)"
   V7215 = "F26 WTR WRK OT (WF-E)"
   V7216 = "F28 SLRY/HRLY/OTR (WF-E)"
   V7217 = "F29 PAY/HRLY SLRY (WF-E)"
   V7218 = "F30 PAY/HR HRLY (WF-E)"
   V7219 = "F31 HOW PAID (WF-E)"
   V7220 = "F32 WTR XTRA JOBS (WF-E)"
   V7221 = "F33 OCC-XTRA JOB (WF-E)"
   V7222 = "F34 #WKS XTRA JOB (WF-E)"
   V7223 = "F35 HR/WK XTR JOB (WF-E)"
   V7224 = "F37 #MI TO WRK (WF-E)"
   V7225 = "F38 MODE TRAV WRK (WF-E)"
   V7226 = "G1 OCC-JOB SOUGHT (WF-U)"
   V7227 = "G2 WTR LKNG JOB (WF-U)"
   V7228 = "G3 #PLAC LKD (WF-U)"
   V7229 = "G4 WKS LK FR WRK (WF-U)"
   V7230 = "G5 EVER HAD JOB (WF-U)"
   V7231 = "G6 OCC-LAST JOB (WF-U)"
   V7232 = "G7 IND-LAST JOB (WF-U)"
   V7233 = "G8 HAPND LAST JOB?(WF-U)"
   V7234 = "G9 YR LAST WRKD (WF-U)"
   V7235 = "G11 WTR VAC (WF-U)"
   V7236 = "G12 #WKS VAC (WF-U)"
   V7237 = "G13 WTR OTR ILL (WF-U)"
   V7238 = "G14 #WKS OTR ILL (WF-U)"
   V7239 = "G15 WTR SELF ILL (WF-U)"
   V7240 = "G16 #WKS SELF ILL (WF-U)"
   V7241 = "G17 WTR STRIKE (WF-U)"
   V7242 = "G18 #WKS STRIKE (WF-U)"
   V7243 = "G19 WTR UNEMP (WF-U)"
   V7244 = "G20 #WKS UNEMP (WF-U)"
   V7245 = "G21 #WKS WRKD (WF-U)"
   V7246 = "G22 HR/WK WRKD (WF-U)"
   V7247 = "G24 #MI TO WRK (WF-U)"
   V7248 = "G25 MODE TRAV WRK (WF-U)"
   V7249 = "H1 WTR RETIRED (WF-R)"
   V7250 = "H2 YR RETIRED (WF-R)"
   V7251 = "H3 WRK FOR $  (WF-R)"
   V7252 = "H4 OCCUPATION (WF-R)"
   V7253 = "H5 INDUSTRY (WF-R)"
   V7254 = "H6 #WKS WRKD (WF-R)"
   V7255 = "H7 HR/WK WRKD (WF-R)"
   V7256 = "H8 WRKNG NOW (WF-R)"
   V7257 = "H9 HPND PRE JOB (WF-R)"
   V7258 = "H10 JOB IN FUT (WF-R)"
   V7259 = "H11 LK FOR JOB (WF-R)"
   V7260 = "H12 #PLAC LKD (WF-R)"
   V7261 = "J1 MARITAL STATUS"
   V7262 = "J2 EVER MARRIED"
   V7263 = "J3 WHT HAPND LST MARR"
   V7264 = "J4 WIFE IN FU"
   V7265 = "J5 #HRS/WK HSEWRK-WF"
   V7266 = "J6 #HRS/WK HSEWRK-HD"
   V7267 = "J8 OTRS HELP HSEWRK"
   V7268 = "J27 ELGBL FOR FD STMPS"
   V7269 = "J28 TRY TO GET FD STMPS"
   V7270 = "J29 WHY CDNT GET FD STMP"
   V7271 = "J30 WHY DDNT TRY FR FDST"
   V7272 = "J30 WHY DDNT TRY FR FDST"
   V7273 = "J31 WHY NOT ELGBL 1ST MN"
   V7274 = "J31 WHY NOT ELGBL 2ND MN"
   V7275 = "K1 HEAD FARMER"
   V7276 = "K2 TOT FARM RECEIPTS BKT"
   V7277 = "K5 WHETHER BUSINESS"
   V7278 = "K6 CORP OR UNINCORP"
   V7279 = "K14 HEAD 65 OR OLDER"
   V7280 = "K15 ELIGIBLE FOR SSI"
   V7281 = "K16 TRY GET SSI"
   V7282 = "K17 WHY COULDNT GET SSI"
   V7283 = "K18 WHY NO TRY GET SSI 1"
   V7284 = "K18 WHY NO TRY GET SSI 2"
   V7285 = "K19 WHY NT ELGBL SSI 1ST"
   V7286 = "K19 WHY NT ELGBL SSI 2ND"
   V7287 = "K60 MEDICAL INSURANCE"
   V7288 = "K61 FREE HOSP OR MED CAR"
   V7289 = "K62 WTR MEDICAID"
   V7290 = "K63 WHICH PROGRAM"
   V7291 = "K64 WTR LUMPSUM PAYMNTS"
   V7292 = "K65 LUMPSUM PMNTS BKT"
   V7293 = "K66 WTR SUPPORT OTHERS"
   V7294 = "K67 #OTRS SUPPORTED"
   V7295 = "K69 WTR DEPENDENT OTRS"
   V7296 = "K70 #OTR DEPENDENTS"
   V7297 = "K71 WTR HELPED IN EMERG"
   V7298 = "K72 HELPED RELAT OR"
   V7299 = "K73 TYPE HELP GAVE 1ST"
   V7300 = "K73 TYPE HELP GAVE 2ND"
   V7301 = "K74 REL/FRND NRBY CLD HP"
   V7302 = "K75 RELATIVE?"
   V7303 = "K76 WHAT IS RELATIONSHIP"
   V7304 = "K77 HOW MUCH MIND"
   V7305 = "K78 REPAY IN SOME WAY?"
   V7306 = "K79 SOMEONE ELSE"
   V7307 = "K80 REL/FRND NOT NEAR"
   V7308 = "K81 RELATIVE?"
   V7309 = "K82 WHAT IS RELATIONSHIP"
   V7310 = "K83 HELP IN LAST 5 YRS"
   V7311 = "K84 TYPE HELP GOT 1ST"
   V7312 = "K84 TYPE HELP GOT 2ND"
   V7313 = "K85 SAVINGS?"
   V7314 = "K86 SAVINGS=2 MOS INC"
   V7315 = "K87 SAVINGS=1 YRS INC"
   V7316 = "K88 WTR SVNG LAST 5 YR"
   V7317 = "K89 FRND/REL LEND $"
   V7318 = "K90 RELATIVE?"
   V7319 = "K91 WHAT IS RELATIONSHIP"
   V7320 = "K92 HOW MCH MND HLP $"
   V7321 = "K93 LOAN OR GIFT"
   V7322 = "K94 PAY INTEREST"
   V7323 = "K95 $  FROM FRND/REL?"
   V7324 = "K96 LOAN OR GIFT"
   V7325 = "K97 PAID INTEREST"
   V7326 = "K98 GIVEN $  TO FRND/REL"
   V7327 = "K99 RELATIVE?"
   V7328 = "K100 WHAT RELATIONSHIP"
   V7329 = "K101 LOAN OR GIFT"
   V7330 = "K102 THEY PAY INTEREST"
   V7331 = "K103 WTR INFLATION HARD"
   V7332 = "K104 1ST HOW INFLAT HARD"
   V7333 = "K104 2ND HOW INFLAT HARD"
   V7334 = "K105 DO ABOUT INFLATION?"
   V7335 = "K106 WHAT DONE 1ST MEN"
   V7336 = "K106 WHAT DONE 2ND MEN"
   V7337 = "K107 INFL VS RETIREMENT"
   V7338 = "K108 HOW CHANGED 1ST MEN"
   V7339 = "K108 HOW CHANGED 2ND MEN"
   V7340 = "K109 UNION MEMBER-HD"
   V7341 = "K110 WIFE IN FU"
   V7342 = "K111 UNION MEMBER-WF"
   V7343 = "K112 WTR HEALTH LMT-HD"
   V7344 = "K113 HW MUCH HLTH LMT-HD"
   V7345 = "L1 WTR NEW WIFE"
   V7346 = "L2 EDUCATION-WF"
   V7347 = "L3 WTR OTR SCHLING-WF"
   V7348 = "L4 TYPE OTR SCHLNG-WF"
   V7349 = "L6 WTR BA/BS DEGREE-WF"
   V7350 = "L7 WTR ADVNCD DEGREE-WF"
   V7351 = "L8 EDUC-WFS FA"
   V7352 = "L9 EDUC-WFS MO"
   V7353 = "L10 #YRS WRKD SINCE 18-W"
   V7354 = "L11 #YRS WRKD FULTME-WF"
   V7355 = "L12 P TIME WRKD-WF"
   V7356 = "L12 ACC P TIME WRKD-WF"
   V7357 = "M1 WTR NEW HEAD"
   V7358 = "M2 ST GREW UP-FA OF HD"
   V7359 = "M2 CO GREW UP-FA OF HD"
   V7360 = "M2 ST GREW UP-MO OF HD"
   V7361 = "M2 GO GREW UP-MO OF HD"
   V7362 = "M3 OCC-FA OF HD"
   V7363 = "M4 OCC-HDS 1ST JOB"
   V7364 = "M5 #DIFF JOBS OR-HD"
   V7365 = "M6-10 AGE OLDEST KID-HD"
   V7366 = "M6-10 AGE 2ND OLD KID-HD"
   V7367 = "M6-10 AGE 3RD OLD KID-HD"
   V7368 = "M6-10 TOT # KIDS -HD"
   V7369 = "M6-10 # KIDS BY 25-HD"
   V7370 = "M11 # SIBLINGS-HD"
   V7371 = "M12 OLDER SIBS?-HD"
   V7372 = "M13 HD GREW UP FARM OR"
   V7373 = "M14,15 ST GREW UP-HD"
   V7374 = "M14,15 CO GREW UP-HD"
   V7375 = "M16 #REGIONS LIVED-HD"
   V7376 = "M16 #STATES LIVED-HD"
   V7377 = "M17 EVER MVD FOR JOB-HD"
   V7378 = "M18 NOT MV FOR JOB-HD"
   V7379 = "M19 PARENTS POOR OR-HD"
   V7380 = "M20-21 EDUC-HDS FA"
   V7381 = "M22-23 EDUC-HDS MO"
   V7382 = "M24 WTR HEAD VET"
   V7383 = "M25 #YR WRK SINCE 18-HD"
   V7384 = "M26 #YR WRK FULLTIME-HD"
   V7385 = "M27 P TIME WRKD-HD"
   V7386 = "M27 ACC P TIME WRK-HD"
   V7387 = "M28 EDUCATION-HD"
   V7388 = "M29 WTR OTR TRNG-HD"
   V7389 = "M30 TYPE OTR TRNG-HD"
   V7390 = "M31 TROUBLE READING?-HD"
   V7391 = "M32 WTR OTR SCHLNG-HD"
   V7392 = "M33 TYPE OTR SCHLNG-HD"
   V7393 = "M35 WTR BA/BS DEGREE-HD"
   V7394 = "M36 WTR ADVANCED DEGR-HD"
   V7395 = "M37 RECORD RELIG PREF"
   V7396 = "M38,39 RELIG PREF"
   V7397 = "N1 WHO RESPONDENT"
   V7398 = "N2 # CALLS"
   V7399 = "H+W 1979 FED TAXES"
   V7400 = "H+W MARGNAL TAX RATE1979"
   V7401 = "1ST XTRA ERNER 79 TAXES"
   V7402 = "MARG TAX RATE ERNR ONE"
   V7403 = "2ND XTRA ERNER 79 TAXES"
   V7404 = "MARG TAX RATE ERNR TWO"
   V7405 = "3RD XTRA ERNER 79 TAXES"
   V7406 = "MARG TAX RATE ERNR THREE"
   V7407 = "4TH XTRA ERNER 79 TAXES"
   V7408 = "MARG TAX RATE ERNR FOUR"
   V7409 = "5TH XTRA ERNER 79 TAXES"
   V7410 = "MARG TAX RATE ERNR FIVE"
   V7411 = "TOT TAXES ALL XTRA ERNR"
   V7412 = "TOT FAM $ Y 79"
   V7413 = "TOT HD LABOR $ Y 79"
   V7414 = "TOT MISC TRAN Y HD+WF 79"
   V7415 = "1979 $ Y/NEEDS"
   V7416 = "ANNUAL FOOD STD"
   V7417 = "HEAD 79 AVG HRLY EARNING"
   V7418 = "WIFE 79 AVG HRLY EARNING"
   V7419 = "REGION 1980 INT"
   V7420 = "REGION 80 HD GREW UP"
   V7421 = "REGION 80 HD FA GREW UP"
   V7422 = "REGION 80 HD MO GREW UP"
   V7423 = "GEOGRAPHIC MOBILITY"
   V7424 = "ACC 79 Y COMPONENTS"
   V7425 = "#MINOR ASSGMTS IN 80"
   V7426 = "#MAJOR ASSGMTS IN 80"
   V7427 = "DU VALUE/ROOM - 1980"
   V7428 = "ACTUL MINUS REQ ROOMS 80"
   V7429 = "PERSON/ROOM IN 1980"
   V7430 = "# 18 OR OLDER IN 80"
   V7431 = "BKT AGE HEAD 1980"
   V7432 = "BKT AGE WIFE 1980"
   V7433 = "EDUCATION 1980 HEAD"
   V7434 = "EDUCATION 1980 WIFE"
   V7435 = "MARITAL STATUS 1980"
   V7436 = "DECILE: 79 TOT FAM $ Y"
   V7437 = "DECILE: 79 $ Y/NEEDS"
   V7438 = "#CHILDS AGE 1-2"
   V7439 = "#CHILDS AGE 3-5"
   V7440 = "#CHILDS AGE 6-13"
   V7441 = "#FEM CHILDS 14-17"
   V7442 = "#MALE CHILDS 14-17"
   V7443 = "#FEM CHILDS 18-20"
   V7444 = "#MALE CHILDS 18-20"
   V7445 = "#FEM CHILDS 21-29"
   V7446 = "#MALE CHILDS 21-29"
   V7447 = "RACE (FROM 1972)"
   V7448 = "SPLIT SAMPLE FILTER"
   V7449 = "SAMP ERR COMP UNIT(SECU)"
   V7450 = "13YR FAM COMP CHANGE"
   V7451 = "1980 FAMILY WEIGHT"
   V7452 = "UNSKL M CNTY LABOR SUPPL"
   V7453 = "TYPICAL UNSKL WAGE RATE"
   V7454 = "1980 CNTY UNEMP RATE"
   V7455 = "79-80 CNG MARITAL STATUS"
   V7456 = "HOUSEHOLD ID # 80"
   V7457 = "FU PRIMACY WITHIN HU";

* USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;

IF V6903=99 THEN V6903=.;
IF V6904=999 THEN V6904=.;
IF V6905=99999 THEN V6905=.;
IF V6906=9 THEN V6906=.;
IF V6908=9 THEN V6908=.;
IF V6909=9 THEN V6909=.;
IF V6927=9 THEN V6927=.;
IF V6928=9 THEN V6928=.;
IF V6969=9 THEN V6969=.;
IF V6978=99 THEN V6978=.;
IF V7035=9 THEN V7035=.;
IF V7063=99 THEN V7063=.;
IF V7064=9999 THEN V7064=.;
IF V7065=999 THEN V7065=.;
IF V7067=99 THEN V7067=.;
IF V7069=99 THEN V7069=.;
IF V7071=99 THEN V7071=.;
IF V7072=9 THEN V7072=.;
IF V7073=9 THEN V7073=.;
IF V7074=9 THEN V7074=.;
IF V7075=9 THEN V7075=.;
IF V7076=9 THEN V7076=.;
IF V7077=9 THEN V7077=.;
IF V7078=9 THEN V7078=.;
IF V7079=99999 THEN V7079=.;
IF V7080=9 THEN V7080=.;
IF V7081=9 THEN V7081=.;
IF V7082=9 THEN V7082=.;
IF V7083=9 THEN V7083=.;
IF V7085=9 THEN V7085=.;
IF V7086=99 THEN V7086=.;
IF V7087=9 THEN V7087=.;
IF V7088=9 THEN V7088=.;
IF V7089=9 THEN V7089=.;
IF V7090=99 THEN V7090=.;
IF V7091=9 THEN V7091=.;
IF V7092=9 THEN V7092=.;
IF V7093=9 THEN V7093=.;
IF V7094=9 THEN V7094=.;
IF V7096=9 THEN V7096=.;
IF V7097=9 THEN V7097=.;
IF V7098=9 THEN V7098=.;
IF V7099=9 THEN V7099=.;
IF V7100=99 THEN V7100=.;
IF V7101=99 THEN V7101=.;
IF V7102=999 THEN V7102=.;
IF V7103=99 THEN V7103=.;
IF V7104=9 THEN V7104=.;
IF V7105=9 THEN V7105=.;
IF V7106=9 THEN V7106=.;
IF V7107=9 THEN V7107=.;
IF V7108=9 THEN V7108=.;
IF V7109=99 THEN V7109=.;
IF V7110=9 THEN V7110=.;
IF V7111=99 THEN V7111=.;
IF V7112=9 THEN V7112=.;
IF V7113=99 THEN V7113=.;
IF V7114=9 THEN V7114=.;
IF V7115=99 THEN V7115=.;
IF V7116=9 THEN V7116=.;
IF V7117=99 THEN V7117=.;
IF V7118=99 THEN V7118=.;
IF V7119=99 THEN V7119=.;
IF V7120=9 THEN V7120=.;
IF V7121=9 THEN V7121=.;
IF V7122=9999 THEN V7122=.;
IF V7123=9 THEN V7123=.;
IF V7124=9999 THEN V7124=.;
IF V7125=9999 THEN V7125=.;
IF V7126=9999 THEN V7126=.;
IF V7127=9 THEN V7127=.;
IF V7128=9999 THEN V7128=.;
IF V7129=9 THEN V7129=.;
IF V7130=99 THEN V7130=.;
IF V7131=9 THEN V7131=.;
IF V7132=9999 THEN V7132=.;
IF V7133=99 THEN V7133=.;
IF V7134=99 THEN V7134=.;
IF V7135=9 THEN V7135=.;
IF V7136=9999 THEN V7136=.;
IF V7137=9 THEN V7137=.;
IF V7138=9 THEN V7138=.;
IF V7139=9 THEN V7139=.;
IF V7140=9 THEN V7140=.;
IF V7141=9 THEN V7141=.;
IF V7142=99 THEN V7142=.;
IF V7143=9 THEN V7143=.;
IF V7144=9 THEN V7144=.;
IF V7145=9 THEN V7145=.;
IF V7146=9 THEN V7146=.;
IF V7147=9 THEN V7147=.;
IF V7148=99 THEN V7148=.;
IF V7149=9999 THEN V7149=.;
IF V7150=9 THEN V7150=.;
IF V7151=9 THEN V7151=.;
IF V7152=9 THEN V7152=.;
IF V7153=9999 THEN V7153=.;
IF V7154=9 THEN V7154=.;
IF V7155=9999 THEN V7155=.;
IF V7156=9 THEN V7156=.;
IF V7157=99 THEN V7157=.;
IF V7158=9 THEN V7158=.;
IF V7159=99 THEN V7159=.;
IF V7160=99 THEN V7160=.;
IF V7161=9 THEN V7161=.;
IF V7162=99 THEN V7162=.;
IF V7163=9 THEN V7163=.;
IF V7164=99 THEN V7164=.;
IF V7165=9 THEN V7165=.;
IF V7166=99 THEN V7166=.;
IF V7167=9 THEN V7167=.;
IF V7168=99 THEN V7168=.;
IF V7169=9 THEN V7169=.;
IF V7170=99 THEN V7170=.;
IF V7171=9 THEN V7171=.;
IF V7172=99 THEN V7172=.;
IF V7173=99 THEN V7173=.;
IF V7174=99 THEN V7174=.;
IF V7175=99 THEN V7175=.;
IF V7176=9 THEN V7176=.;
IF V7178=99 THEN V7178=.;
IF V7179=9 THEN V7179=.;
IF V7180=99 THEN V7180=.;
IF V7181=99 THEN V7181=.;
IF V7182=99 THEN V7182=.;
IF V7183=99 THEN V7183=.;
IF V7184=9 THEN V7184=.;
IF V7185=9 THEN V7185=.;
IF V7186=9 THEN V7186=.;
IF V7187=99 THEN V7187=.;
IF V7188=9 THEN V7188=.;
IF V7189=9 THEN V7189=.;
IF V7190=9 THEN V7190=.;
IF V7191=9 THEN V7191=.;
IF V7194=9 THEN V7194=.;
IF V7195=9 THEN V7195=.;
IF V7196=9 THEN V7196=.;
IF V7197=9 THEN V7197=.;
IF V7198=99 THEN V7198=.;
IF V7199=99 THEN V7199=.;
IF V7200=999 THEN V7200=.;
IF V7201=99 THEN V7201=.;
IF V7202=9 THEN V7202=.;
IF V7203=9 THEN V7203=.;
IF V7204=99 THEN V7204=.;
IF V7205=9 THEN V7205=.;
IF V7206=99 THEN V7206=.;
IF V7207=9 THEN V7207=.;
IF V7208=99 THEN V7208=.;
IF V7209=9 THEN V7209=.;
IF V7210=99 THEN V7210=.;
IF V7211=9 THEN V7211=.;
IF V7212=99 THEN V7212=.;
IF V7213=99 THEN V7213=.;
IF V7214=99 THEN V7214=.;
IF V7215=9 THEN V7215=.;
IF V7216=9 THEN V7216=.;
IF V7217=9999 THEN V7217=.;
IF V7218=9999 THEN V7218=.;
IF V7219=9 THEN V7219=.;
IF V7220=9 THEN V7220=.;
IF V7221=99 THEN V7221=.;
IF V7222=99 THEN V7222=.;
IF V7223=99 THEN V7223=.;
IF V7224=99 THEN V7224=.;
IF V7225=9 THEN V7225=.;
IF V7226=99 THEN V7226=.;
IF V7227=9 THEN V7227=.;
IF V7228=9 THEN V7228=.;
IF V7229=99 THEN V7229=.;
IF V7230=9 THEN V7230=.;
IF V7231=99 THEN V7231=.;
IF V7232=99 THEN V7232=.;
IF V7233=9 THEN V7233=.;
IF V7234=99 THEN V7234=.;
IF V7235=9 THEN V7235=.;
IF V7236=99 THEN V7236=.;
IF V7237=9 THEN V7237=.;
IF V7238=99 THEN V7238=.;
IF V7239=9 THEN V7239=.;
IF V7240=99 THEN V7240=.;
IF V7241=9 THEN V7241=.;
IF V7242=99 THEN V7242=.;
IF V7243=9 THEN V7243=.;
IF V7244=99 THEN V7244=.;
IF V7245=99 THEN V7245=.;
IF V7246=99 THEN V7246=.;
IF V7247=99 THEN V7247=.;
IF V7248=9 THEN V7248=.;
IF V7250=99 THEN V7250=.;
IF V7251=9 THEN V7251=.;
IF V7252=99 THEN V7252=.;
IF V7253=99 THEN V7253=.;
IF V7254=99 THEN V7254=.;
IF V7255=99 THEN V7255=.;
IF V7256=9 THEN V7256=.;
IF V7257=9 THEN V7257=.;
IF V7258=9 THEN V7258=.;
IF V7259=9 THEN V7259=.;
IF V7260=9 THEN V7260=.;
IF V7262=9 THEN V7262=.;
IF V7263=9 THEN V7263=.;
IF V7265=99 THEN V7265=.;
IF V7266=99 THEN V7266=.;
IF V7267=9 THEN V7267=.;
IF V7268=9 THEN V7268=.;
IF V7269=9 THEN V7269=.;
IF V7270=9 THEN V7270=.;
IF V7271=9 THEN V7271=.;
IF V7273=9 THEN V7273=.;
IF V7275=9 THEN V7275=.;
IF V7276=9 THEN V7276=.;
IF V7277=9 THEN V7277=.;
IF V7278=9 THEN V7278=.;
IF V7280=9 THEN V7280=.;
IF V7281=9 THEN V7281=.;
IF V7282=9 THEN V7282=.;
IF V7283=9 THEN V7283=.;
IF V7285=9 THEN V7285=.;
IF V7287=9 THEN V7287=.;
IF V7288=9 THEN V7288=.;
IF V7289=9 THEN V7289=.;
IF V7290=9 THEN V7290=.;
IF V7291=9 THEN V7291=.;
IF V7292=9 THEN V7292=.;
IF V7293=9 THEN V7293=.;
IF V7294=9 THEN V7294=.;
IF V7295=9 THEN V7295=.;
IF V7296=9 THEN V7296=.;
IF V7297=9 THEN V7297=.;
IF V7298=9 THEN V7298=.;
IF V7299=9 THEN V7299=.;
IF V7301=9 THEN V7301=.;
IF V7302=9 THEN V7302=.;
IF V7303=9 THEN V7303=.;
IF V7304=9 THEN V7304=.;
IF V7305=9 THEN V7305=.;
IF V7306=9 THEN V7306=.;
IF V7307=9 THEN V7307=.;
IF V7308=9 THEN V7308=.;
IF V7309=9 THEN V7309=.;
IF V7310=9 THEN V7310=.;
IF V7311=9 THEN V7311=.;
IF V7313=9 THEN V7313=.;
IF V7314=9 THEN V7314=.;
IF V7315=9 THEN V7315=.;
IF V7316=9 THEN V7316=.;
IF V7317=9 THEN V7317=.;
IF V7318=9 THEN V7318=.;
IF V7319=9 THEN V7319=.;
IF V7320=9 THEN V7320=.;
IF V7321=9 THEN V7321=.;
IF V7322=9 THEN V7322=.;
IF V7323=9 THEN V7323=.;
IF V7324=9 THEN V7324=.;
IF V7325=9 THEN V7325=.;
IF V7326=9 THEN V7326=.;
IF V7327=9 THEN V7327=.;
IF V7328=9 THEN V7328=.;
IF V7329=9 THEN V7329=.;
IF V7330=9 THEN V7330=.;
IF V7331=9 THEN V7331=.;
IF V7332=99 THEN V7332=.;
IF V7334=9 THEN V7334=.;
IF V7335=99 THEN V7335=.;
IF V7337=9 THEN V7337=.;
IF V7338=99 THEN V7338=.;
IF V7340=9 THEN V7340=.;
IF V7342=9 THEN V7342=.;
IF V7343=9 THEN V7343=.;
IF V7344=9 THEN V7344=.;
IF V7346=99 THEN V7346=.;
IF V7347=9 THEN V7347=.;
IF V7348=9 THEN V7348=.;
IF V7349=9 THEN V7349=.;
IF V7350=9 THEN V7350=.;
IF V7351=9 THEN V7351=.;
IF V7352=9 THEN V7352=.;
IF V7353=99 THEN V7353=.;
IF V7354=99 THEN V7354=.;
IF V7358=99 THEN V7358=.;
IF V7359=999 THEN V7359=.;
IF V7360=99 THEN V7360=.;
IF V7361=999 THEN V7361=.;
IF V7364=9 THEN V7364=.;
IF V7365=99 THEN V7365=.;
IF V7366=99 THEN V7366=.;
IF V7367=99 THEN V7367=.;
IF V7368=99 THEN V7368=.;
IF V7369=9 THEN V7369=.;
IF V7370=9 THEN V7370=.;
IF V7371=9 THEN V7371=.;
IF V7372=9 THEN V7372=.;
IF V7373=99 THEN V7373=.;
IF V7374=999 THEN V7374=.;
IF V7375=9 THEN V7375=.;
IF V7376=9 THEN V7376=.;
IF V7377=9 THEN V7377=.;
IF V7378=9 THEN V7378=.;
IF V7379=9 THEN V7379=.;
IF V7380=9 THEN V7380=.;
IF V7381=9 THEN V7381=.;
IF V7382=9 THEN V7382=.;
IF V7383=99 THEN V7383=.;
IF V7384=99 THEN V7384=.;
IF V7387=99 THEN V7387=.;
IF V7388=9 THEN V7388=.;
IF V7389=9 THEN V7389=.;
IF V7390=9 THEN V7390=.;
IF V7391=9 THEN V7391=.;
IF V7392=9 THEN V7392=.;
IF V7393=9 THEN V7393=.;
IF V7394=9 THEN V7394=.;
IF V7395=9 THEN V7395=.;
IF V7397=9 THEN V7397=.;
IF V7398=9 THEN V7398=.;
IF V7427=99999 THEN V7427=.;
IF V7428=9 THEN V7428=.;
IF V7429=9.9 THEN V7429=.;
IF V7431=9 THEN V7431=.;
IF V7432=9 THEN V7432=.;
IF V7433=9 THEN V7433=.;
IF V7434=9 THEN V7434=.;
IF V7452=9 THEN V7452=.;
IF V7453=9 THEN V7453=.;
IF V7454=9 THEN V7454=.;
 
file rawdat lrecl=1100;
put    
v6902
v6910
v6917
v6918
v6919
v6925
v6926
v6931
v6932
v6934
v6935
v6936
v6938
v6946
v6947
v6948
v6950
v6962
v6970
v6971
v6972
v6973
v6974
v6975
v6976
v6977
v6987
v6988
v6989
v6994
v6996
v6998
v7016
v7032
v7033
v7035
v7046
v7064
v7066
v7067
v7068
v7069
v7078
v7084
v7085
v7086
v7087
v7089
v7090
v7091
v7095
v7096
v7104
v7118
v7119
v7157
v7161
v7173
v7174
v7193
v7194
v7202
v7213
v7214
v7229
v7233
v7245
v7246
v7256
v7292
v7294
v7343
v7346
v7349
v7357
v7387
v7393
v7399
v7400
v7411
v7412
v7413
v7419
v7424
v7433
v7434
v7435
v7447
v7451
v30326
;

 proc means;
 run; 
